/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYX0;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZOz = new ArrayList();
    private final Map<String, DataColumn> zzXWr = new HashMap<String, DataColumn>();
    private DataTable zzYr0;

    DataColumnCollection(DataTable table) {
        this.zzYr0 = table;
    }

    public void add(DataColumn column) {
        if (zzYX0.zzWUu(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZxY(column.getColumnName());
        if (this.zzXWr.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzUt(this.zzYr0);
        column.setOrdinal(this.zzZOz.size());
        this.zzZOz.add(column);
        this.zzXWr.put(string, column);
        this.zzYr0.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYr0);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYr0);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzYX0.zzWUu(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZxY(columnName);
        DataColumn dataColumn = this.zzXWr.get(string);
        if (dataColumn != null) {
            int n = this.zzZOz.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZOz.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZOz.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZOz.remove(n);
            this.zzXWr.remove(DataColumnCollection.zzZxY(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYr0.getRows()) {
                dataRow.remove(n);
            }
            this.zzYr0.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZOz.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZOz.iterator();
    }

    public void clear() {
        this.zzXWr.clear();
        this.zzZOz.clear();
    }

    final DataColumn[] zzWBu() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZOz);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYyt(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZOz.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZOz.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZxY(string);
            String string3 = DataColumnCollection.zzZxY(dataColumn.getColumnName());
            this.zzXWr.remove(string3);
            this.zzXWr.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZxY(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

