/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZpG;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW9A;
import com.aspose.words.net.System.Data.zzWII;
import com.aspose.words.net.System.Data.zzXUn;
import com.aspose.words.net.System.Data.zzYcj;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYT8;
    private final DataColumnCollection zzXuA;
    private final ConstraintCollection zzXJW;
    private final zzW9A zzZHY;
    private ResultSet zzMb;
    private String zzYPa;
    private DataSet zzXim;
    private String zzx9;
    private UniqueConstraint zzYqY;
    private boolean zzNp;
    private final List<DataTableEventListener> zzYuX;
    private final Set<DataRow> zzY0I;
    private DataRelationCollection zzd5;

    public DataTable() {
        this.zzYT8 = new DataRowCollection(this);
        this.zzXuA = new DataColumnCollection(this);
        this.zzXJW = new ConstraintCollection(this);
        this.zzZHY = new zzW9A(this);
        this.zzx9 = "";
        this.zzNp = true;
        this.zzYuX = new ArrayList<DataTableEventListener>();
        this.zzY0I = new HashSet<DataRow>();
        this.zzd5 = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzYT8 = new DataRowCollection(this);
        this.zzXuA = new DataColumnCollection(this);
        this.zzXJW = new ConstraintCollection(this);
        this.zzZHY = new zzW9A(this);
        this.zzx9 = "";
        this.zzNp = true;
        this.zzYuX = new ArrayList<DataTableEventListener>();
        this.zzY0I = new HashSet<DataRow>();
        this.zzd5 = new DataRelationCollection();
        this.zzYPa = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYcj.zzYyt(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYT8 = new DataRowCollection(this);
        this.zzXuA = new DataColumnCollection(this);
        this.zzXJW = new ConstraintCollection(this);
        this.zzZHY = new zzW9A(this);
        this.zzx9 = "";
        this.zzNp = true;
        this.zzYuX = new ArrayList<DataTableEventListener>();
        this.zzY0I = new HashSet<DataRow>();
        this.zzd5 = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzMb = resultSet;
        this.zzYPa = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzMb != null) {
            if (this.zzMb.getStatement() != null) {
                this.zzMb.getStatement().getConnection().close();
            }
            this.zzMb = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYPa;
    }

    public void setTableName(String tableName) {
        this.zzYPa = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXuA.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXuA.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzMb;
    }

    public DataSet getDataSet() {
        return this.zzXim;
    }

    final void zzUt(DataSet dataSet) {
        this.zzXim = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXim.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzd5.add(dataRelation);
        }
        return this.zzd5;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXim.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYT8;
    }

    public DataColumnCollection getColumns() {
        return this.zzXuA;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXJW;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYqY == null) {
            return new DataColumn[0];
        }
        return this.zzYqY.getColumns();
    }

    final void zzW9A(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYqY != null) {
                this.zzYqY.zzYjM(false);
                this.getConstraints().remove(this.zzYqY);
                this.zzYqY = null;
            }
            return;
        }
        if (this.zzYqY != null && DataColumn.areColumnSetsTheSame(value, this.zzYqY.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYyt(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYqY != null) {
            this.zzYqY.zzYjM(false);
            this.getConstraints().remove(this.zzYqY);
            this.zzYqY = null;
        }
        UniqueConstraint.zzYyt(this.getConstraints(), uniqueConstraint);
        this.zzYqY = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzx9;
    }

    public void setNamespace(String namespace) {
        this.zzx9 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzNp;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzNp = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzY0I.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYcj.zzYyt(this.getResultSet(), this);
            zzYcj.zzYcj(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZpG.zzUt(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYcj.zzaM(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYuX.contains(listener)) {
            this.zzYuX.add(listener);
        }
    }

    public void removeEventListener(zzWII listener) {
        if (this.zzYuX.contains(listener)) {
            this.zzYuX.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYuX.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzY0I.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYuX) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzY0I.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYuX) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzY0I.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYuX) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYuX) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYuX) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXUn zzYyt(zzYcj[] zzYcjArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYcjArray.length];
        for (int i = 0; i < zzYcjArray.length; ++i) {
            dataColumnArray[i] = zzYcjArray[i].zzZHO();
        }
        DataTable dataTable = this;
        zzXUn zzXUn2 = dataTable.zzZHY.zzUt(dataColumnArray);
        if (zzXUn2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXUn2;
    }

    final zzW9A zzXOU() {
        return this.zzZHY;
    }

    final Set<DataRow> zzYjE() {
        return this.zzY0I;
    }
}

