/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzLF;
import com.aspose.words.zzXHT;
import com.aspose.words.zzXpu;
import com.aspose.words.zzZam;
import com.aspose.words.zzZwt;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzXHT,
Iterable<T> {
    private Node zzWqu;
    private CompositeNode zzZyg;
    private DocumentBase zzXOY;
    private boolean zzXQU;
    private int zzYTY;
    private int zzY0h;
    private Node zzYNR;
    private int zzYjG;
    private zzZam zzXlL;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzXpu.zzYX1(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzXpu(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZam matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZyg = container;
        this.zzXOY = container.getDocument();
        this.zzXlL = matcher;
        this.zzXQU = isDeep;
        this.zzY3j();
    }

    public Node get(int index) {
        try {
            this.zzZW6();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzY0h == index) {
                return this.zzYNR;
            }
            int n = index - this.zzY0h;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzYOh(nodeCollection.zzYNR, n);
            if (node != null) {
                this.zzY0h = index;
                this.zzYNR = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzXQU) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZyg.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzXQU) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZyg.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzW9Z();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZwt(this);
    }

    final <TNode extends Node> zzZwt<TNode> zz0V() {
        return new zzZwt(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzW9Z() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzLF.zzYyt(arrayList, node);
        }
        return arrayList;
    }

    private Node zzYOh(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzXF2(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzXac(curNode, true);
    }

    private Node zzXac(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzWqu = node;
        do {
            node2 = this.zzWqu;
            Node node3 = this.zzXQU ? this.zzYyt(true, this.zzWqu) : (this.zzWqu = this.zzXlL.zzXSW() ? this.zzWII(true, this.zzWqu) : this.zzYcj(true, this.zzWqu));
        } while (this.zzWqu != null && !this.zzXlL.zzZGH(this.zzWqu));
        return node2;
    }

    private Node zzXF2(Node node, boolean bl) throws Exception {
        while ((this.zzXQU ? this.zzYyt(bl, node) : (node = this.zzXlL.zzXSW() ? this.zzWII(bl, node) : this.zzYcj(bl, node))) != null && !this.zzXlL.zzZGH(node)) {
        }
        return node;
    }

    private Node zzYyt(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZyg);
        }
        return node.previousPreOrder(this.zzZyg);
    }

    private Node zzYcj(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZyg) {
                return this.zzZyg.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZyg) {
            return this.zzZyg.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWII(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZyg ? this.zzZyg.zzYty() : node.zzZ7U();
        } else {
            Node node3 = node2 = node == this.zzZyg ? this.zzZyg.zzYS1() : node.zzXss();
        }
        if (node2 == this.zzZyg.getNextSibling() || node2 == this.zzZyg.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZW6() {
        if (this.zzYTY != this.zzWgC()) {
            this.zzY3j();
        }
    }

    private void zzY3j() {
        this.zzYTY = this.zzWgC();
        this.zzY0h = -1;
        this.zzYNR = this.zzZyg;
        this.zzYjG = -1;
    }

    private int zzWgC() {
        if (this.zzXOY != null) {
            return this.zzXOY.zzXLV();
        }
        return 0;
    }

    public int getCount() {
        this.zzZW6();
        if (this.zzYjG == -1) {
            this.zzYjG = zzZwt.zzYyt(this);
        }
        return this.zzYjG;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWqu;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZyg;
    }
}

