/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz0q;
import com.aspose.words.internal.zz7l;
import com.aspose.words.internal.zzW1j;
import com.aspose.words.internal.zzWYN;
import com.aspose.words.internal.zzYX0;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.internal.zzZ8W;
import com.aspose.words.zzYHs;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZ3M;
    private zzYHs zzW2P;

    Watermark(Document doc, zzYHs watermarkProvider) {
        this.zzZ3M = doc;
        this.zzW2P = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzW3q(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYyt(text, textWatermarkOptions, this.zzZ3M);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYlQ.zzYcj((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZ3M, 75);
        shape.getImageData().setImage(image);
        this.zzYyt(shape, options, this.zzZ3M);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYlQ.zzYcj((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZ3M, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYyt(shape, options, this.zzZ3M);
    }

    public final int getType() {
        Shape shape = this.zzW2P.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYO7();
        if (shape.zzXLl()) {
            return 0;
        }
        if (shape.zzYNA()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzW2P.add(shape);
    }

    public final void remove() {
        this.zzW2P.remove();
    }

    private static void zzW3q(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zz0q.zzWym(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYlQ.zzYyt(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYyt(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYcj(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzaM(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYcj(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXsS() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzW5m()) / d2) > (double)(f = pageSetup.zzVX2())) {
            d = (double)f / d3;
        }
        shape.zzZSL(zzZ8W.zzWII(d2 * d, 2, zzW1j.zzYj3));
        shape.zzYrT(zzZ8W.zzWII(d3 * d, 2, zzW1j.zzYj3));
    }

    private Shape zzYyt(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYyt(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzaM(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYyt(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXmR() ? 1.0f : textWatermarkOptions.getFontSize();
        zzWYN zzWYN2 = document.zzW4r().zzWII(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzWYN2.zzWkO(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXmR()) {
            l = Watermark.zzYyt(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZSL(zzZ8W.zzWII(Float.intBitsToFloat(n), 2, zzW1j.zzYj3));
        shape.zzYrT(zzZ8W.zzWII(zz7l.zzWsT(l), 2, zzW1j.zzYj3));
    }

    private static long zzYyt(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzW5m();
        float f2 = pageSetup.zzVX2();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zz7l.zzWsT(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zz7l.zzW6I(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zz7l.zzWsT(l) >= Float.intBitsToFloat(n)) {
            return zz7l.zzW6I(f2 / f3, f2);
        }
        float f6 = f;
        return zz7l.zzW6I(f6, f6 * f3);
    }

    private static void zzaM(Shape shape, String string) {
        shape.setName(zzYX0.zzYcj("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

