/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzVZm;
import com.aspose.words.internal.zzWQ6;
import com.aspose.words.internal.zzWXU;
import com.aspose.words.internal.zzYqZ;
import com.aspose.words.internal.zzYy2;
import com.aspose.words.internal.zzZD0;
import com.aspose.words.internal.zzZYh;
import com.aspose.words.internal.zzZcf;
import com.aspose.words.internal.zzrW;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzWwn
extends CertPathBuilderSpi {
    private final zzZcf zzYoB;
    private zzWXU zzZPn;

    zzWwn(zzZcf zzZcf2) {
        this.zzYoB = zzZcf2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZYh pkixParams;
        if (params instanceof zzZYh) {
            pkixParams = (zzZYh)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZYh.zzYyt((PKIXBuilderParameters)params).zzZHI();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZYh.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYy2 zzYy22 = pkixParams.zzYP6().zzYKk();
        try {
            collection = zzrW.zzYyt(zzYy22, pkixParams.zzYP6().zzY5o());
            collection.addAll(zzrW.zzYyt(zzYy22, pkixParams.zzYP6().zzYxJ()));
        }
        catch (zzWXU zzWXU2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzWXU2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYyt(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzZPn != null) {
            throw new CertPathBuilderException(this.zzZPn.getMessage(), this.zzZPn.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYyt(X509Certificate x509Certificate, zzZYh zzZYh2, List list) throws CertPathBuilderException {
        zzWQ6 zzWQ62;
        zzVZm zzVZm2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZYh2.zzXhm().contains(x509Certificate)) {
            return null;
        }
        if (zzZYh2.zzZgL() != -1 && list.size() - 1 > zzZYh2.zzZgL()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzVZm2 = new zzVZm(this.zzYoB);
            zzWQ62 = new zzWQ6(this.zzYoB);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzrW.zzYyt(x509Certificate, zzZYh2.zzYP6().zzXb5(), zzZYh2.zzYP6().zzYGx()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzVZm2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzWXU("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWQ62.engineValidate(certPath, zzZYh2);
                }
                catch (Exception exception) {
                    throw new zzWXU("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZD0> arrayList = new ArrayList<zzZD0>();
            arrayList.addAll(zzZYh2.zzYP6().zzY5o());
            try {
                arrayList.addAll(zzrW.zzYyt(x509Certificate.getExtensionValue(zzYqZ.zzWyE.getId()), zzZYh2.zzYP6().zzJX()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzWXU("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzrW.zzYyt(x509Certificate, zzZYh2.zzYP6().zzYxJ(), arrayList));
            }
            catch (zzWXU zzWXU2) {
                throw new zzWXU("Cannot find issuer certificate for certificate in certification path.", zzWXU2);
            }
            if (hashSet.isEmpty()) {
                throw new zzWXU("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYyt(x509Certificate2, zzZYh2, list);
            }
        }
        catch (zzWXU zzWXU3) {
            this.zzZPn = zzWXU3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

