/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzYZY;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWHf;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzWHf zzSx;

    BorderCollection(zzWHf parent) {
        this.zzSx = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzYlQ.zzje(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zziT().equals(brColl.zziT()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzSx.getPossibleBorderKeys().zzYyt(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzSx.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzSx, borderKey);
            this.zzSx.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzSx.getPossibleBorderKeys().zzY12().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzSx.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzSx.getPossibleBorderKeys().zzY12().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZJk(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzSx.getPossibleBorderKeys().zzY12().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZJk(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zziT().zzWj4();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZQg(zzYZY.zzYcj(value));
    }

    private zzYZY zziT() throws Exception {
        return this.get(0).zziT();
    }

    private void zzZQg(zzYZY zzYZY2) throws Exception {
        Iterator iterator = this.zzSx.getPossibleBorderKeys().zzY12().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZJk(n)) continue;
            this.getByBorderType(n).zzZQg(zzYZY2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzSx.getPossibleBorderKeys().zzY12().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZJk(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzSx.getPossibleBorderKeys().zzY12().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZJk(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzYyt(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzZJk(int n) {
        return n != 6 && n != 7;
    }

    static final class zzYyt
    implements Iterator<Border> {
        private BorderCollection zzwC;
        private int zzYZT;

        zzYyt(BorderCollection borderCollection) {
            this.zzwC = borderCollection;
            this.zzYZT = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzYZT >= this.zzwC.getCount() - 1) {
                return false;
            }
            ++this.zzYZT;
            return true;
        }

        private Border zzZVT() {
            try {
                return this.zzwC.get(this.zzYZT);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzZVT();
        }
    }
}

