/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWa7;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.zzW2S;
import com.aspose.words.zzXSc;
import com.aspose.words.zzXtZ;
import com.aspose.words.zzYLY;
import com.aspose.words.zzYOn;
import com.aspose.words.zzYTQ;
import com.aspose.words.zzYXu;
import com.aspose.words.zzZ2v;
import com.aspose.words.zzZGx;
import com.aspose.words.zzhZ;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZ2v zzY20;

    ChartSeriesCollection(zzZ2v dmlChart) {
        this.zzY20 = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY20.zzWYI().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY20.zzWYI().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzY20.zzWYI().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzY20.zzWYI().clear();
        this.zzY7T(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYyt(seriesName, values);
        chartSeries.zzYOa().zzUt(ChartSeriesCollection.zzje(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYyt(seriesName, yValues);
        chartSeries.zzYOa().zzUt(ChartSeriesCollection.zzUt(xValues));
        return chartSeries;
    }

    private ChartSeries zzYyt(String string, zzWa7[] zzWa7Array, double[] dArray) {
        if (zzWa7Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWa7Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWa7Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYyt(string, dArray);
        chartSeries.zzYOa().zzUt(ChartSeriesCollection.zzYyt(zzWa7Array));
        if (!this.zzY20.zzZS6()) {
            this.zzY7T(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYyt(seriesName, zzWa7.zzYyt(dates), values);
    }

    private void zzY7T(boolean bl) {
        zzXSc zzXSc2 = zzYlQ.zzYyt((Object)this.zzY20, zzXSc.class);
        if (zzXSc2 != null && zzXSc2.zzZoj().zzWpt()) {
            zzXSc2.zzZoj().zzXXF().zzje(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzY20.zzXaR() != 15) {
            this.zzY20.zzW9A(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYyt(seriesName, yValues);
        chartSeries.zzZt0().zzYUy().zzje(3, this.zzY20.zzan());
        chartSeries.zzYOa().zzUt(ChartSeriesCollection.zzUt(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzOJ().zzUt(ChartSeriesCollection.zzUt(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYyt(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzY20);
        chartSeries.setName(string);
        this.zzYZU(chartSeries);
        chartSeries.zzXta(this.zzY20.zzX2V().zzWH4() + 1);
        chartSeries.zzZRO(this.zzY20.zzX2V().zzWUz() + 1);
        chartSeries.zzWBI().zzUt(ChartSeriesCollection.zzUt(dArray));
        this.zzY20.zzYZN().zzUk();
        this.zzY20.zzWYI().zzZ3u(chartSeries);
        return chartSeries;
    }

    private void zzYZU(ChartSeries chartSeries) {
        chartSeries.zzZt0().zzYUy().zzje(5, new zzhZ());
        switch (this.zzY20.zzXaR()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYyt(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYyt(chartSeries, 5);
                ChartSeriesCollection.zzXze(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYyt(chartSeries, 1);
                ChartSeriesCollection.zzXze(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzY7U(chartSeries);
            }
        }
    }

    private static void zzY7U(ChartSeries chartSeries) {
        zzhZ zzhZ2 = new zzhZ();
        zzhZ2.setOutline(new zzYTQ());
        zzZGx zzZGx2 = new zzZGx();
        zzZGx2.zzXTz(1);
        zzhZ2.getOutline().setFill(new zzYLY(zzZGx2));
        zzhZ2.getOutline().zzWj7(19050.0);
        chartSeries.zzZt0().zzYUy().zzje(5, zzhZ2);
    }

    private static void zzXze(ChartSeries chartSeries) {
        zzhZ zzhZ2 = new zzhZ();
        zzhZ2.setOutline(new zzYTQ());
        zzhZ2.getOutline().setFill(new zzYXu());
        zzhZ2.getOutline().setEndCap(0);
        zzhZ2.getOutline().zzWj7(19050.0);
        chartSeries.zzZt0().zzYUy().zzje(5, zzhZ2);
    }

    private static void zzYyt(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZHb());
        chartMarker.zzXj5().zzje(0, n);
        chartSeries.zzZt0().zzYUy().zzje(4, chartMarker);
    }

    private static zzXtZ zzUt(double[] dArray) {
        int n = 0;
        zzXtZ zzXtZ2 = new zzXtZ(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXtZ2.zzWCn(new zzW2S(n, d, "General"));
            }
            ++n;
        }
        zzXtZ2.zzWHW(dArray.length);
        return zzXtZ2;
    }

    private static zzXtZ zzYyt(zzWa7[] zzWa7Array) {
        int n = 0;
        zzXtZ zzXtZ2 = new zzXtZ(2);
        zzWa7[] zzWa7Array2 = zzWa7Array;
        int n2 = zzWa7Array.length;
        for (int i = 0; i < n2; ++i) {
            zzWa7 zzWa72 = zzWa7Array2[i];
            zzXtZ2.zzWCn(new zzW2S(n++, zzWa72.zzX2c(), "m/d/yyyy"));
        }
        zzXtZ2.zzWHW(zzWa7Array.length);
        return zzXtZ2;
    }

    private static zzXtZ zzje(String[] stringArray) {
        int n = 0;
        zzXtZ zzXtZ2 = new zzXtZ(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXtZ2.zzWCn(new zzYOn(n++, string));
        }
        zzXtZ2.zzWHW(stringArray.length);
        return zzXtZ2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY20.zzWYI().getCount();
    }
}

