/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz5f;
import com.aspose.words.internal.zzVYk;
import com.aspose.words.internal.zzWFc;
import com.aspose.words.internal.zzWVE;
import com.aspose.words.internal.zzWXz;
import com.aspose.words.internal.zzWfI;
import com.aspose.words.internal.zzYX0;
import com.aspose.words.internal.zzYcE;
import com.aspose.words.internal.zzYgi;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.internal.zzZ2c;
import com.aspose.words.internal.zzgJ;
import com.aspose.words.zz47;
import com.aspose.words.zzW99;
import com.aspose.words.zzWGG;
import com.aspose.words.zzWnX;
import com.aspose.words.zzX0t;
import com.aspose.words.zzXB4;
import com.aspose.words.zzXFm;
import com.aspose.words.zzXzZ;
import com.aspose.words.zzYbK;
import com.aspose.words.zzYuN;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYyt(zzWFc zzWFc2, zzWFc zzWFc3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYlQ.zzYcj((Object)zzWFc2, "srcStream");
        zzYlQ.zzYcj((Object)zzWFc3, "dstStream");
        zzYlQ.zzYcj((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYcj(zzWFc2, zzWFc3, certificateHolder, signOptions);
        zzWFc3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYyt(zzWFc.zzYcj(srcStream), (zzWFc)zzWFc.zzWII(dstStream), certHolder, signOptions);
    }

    private static void zzYcj(zzWFc zzWFc2, zzWFc zzWFc3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWII(digitalSignature);
        }
        if (zzYbK.zzXpR(zzWFc2)) {
            DigitalSignatureUtil.zzYyt(zzWFc2, zzWFc3, digitalSignature, true);
            return;
        }
        zzYbK zzYbK2 = new zzYbK();
        zzWFc zzWFc4 = zzWFc2;
        zzYbK zzYbK3 = zzYbK2;
        FileFormatInfo fileFormatInfo = zzYbK2.zzYcj(zzWFc4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWVE zzWVE2 = new zzWVE(zzWFc2);
                int n = fileFormatInfo.zzZtu() == 1 ? 1 : 2;
                zzWGG.zzYyt(zzWVE2, digitalSignature, n);
                zzWFc3.zzYZc(0L);
                zzWVE2.zzVQ7(zzWFc3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYyt(fileFormatInfo.zzP6(), zzWFc3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYyt(zzWFc2, zzWFc3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYyt(zzWFc2, zzWFc3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYlQ.zzYcj(srcFileName, "srcFileName");
        zzYlQ.zzYcj(dstFileName, "dstFileName");
        try (zzYgi zzYgi2 = zzYlQ.zzYcj(srcFileName, 3, 1);){
            try (zzYgi zzYgi3 = zzYlQ.zzYcj(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYyt((zzWFc)zzYgi2, (zzWFc)zzYgi3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzgJ zzgJ2 = zzWFc.zzWII(dstStream);
        zzWFc zzWFc2 = zzWFc.zzYcj(srcStream);
        DigitalSignatureUtil.zzYyt(zzWFc2, (zzWFc)zzgJ2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzYgi zzYgi2 = zzYlQ.zzYcj(srcFileName, 3, 1);){
            try (zzYgi zzYgi3 = zzYlQ.zzYcj(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzUt(zzYgi2, zzYgi3);
            }
            return;
        }
    }

    private static void zzUt(zzWFc zzWFc2, zzWFc zzWFc3) throws Exception {
        zzYbK zzYbK2 = new zzYbK();
        zzWFc zzWFc4 = zzWFc2;
        zzYbK zzYbK3 = zzYbK2;
        FileFormatInfo fileFormatInfo = zzYbK2.zzYcj(zzWFc4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWVE zzWVE2 = new zzWVE(zzWFc2);
                zzWVE2.zzBj().zz2P("_xmlsignatures");
                zzWVE2.zzBj().zz2P("_signatures");
                zzWFc3.zzWzT(0L);
                zzWVE2.zzVQ7(zzWFc3);
                zzWFc zzWFc5 = zzWFc3;
                zzWFc5.zzYZc(zzWFc5.zzsJ());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzVYk zzVYk2 = new zzVYk(zzWFc2);
                zzWfI zzWfI2 = zzVYk2.zzYyt(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzWfI2 != null) {
                    for (zzZ2c zzZ2c2 : zzWfI2.zzWMg()) {
                        String string = zzWfI2.zzYyt(zzZ2c2);
                        zzVYk2.zzZdI().remove(string);
                    }
                    zzVYk2.zzZdI().remove(zzWfI2.getName());
                    zzZ2c zzZ2c3 = zzVYk2.zzWMg().zzXcj("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzVYk2.zzWMg().remove(zzZ2c3.getId());
                    zzVYk2.zzZkx();
                }
                zzWFc3.zzWzT(0L);
                zzVYk2.zzVQ7(zzWFc3);
                zzWFc zzWFc6 = zzWFc3;
                zzWFc6.zzYZc(zzWFc6.zzsJ());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzUt(zzWFc.zzYcj(srcStream), zzWFc.zzWII(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzYgi zzYgi2 = zzYlQ.zzYcj(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzWCF(zzYgi2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzWCF(zzWFc zzWFc2) throws Exception {
        if (zzYbK.zzXpR(zzWFc2)) {
            return DigitalSignatureUtil.zzXOf(zzWFc2);
        }
        zzYbK zzYbK2 = new zzYbK();
        zzWFc zzWFc3 = zzWFc2;
        zzYbK zzYbK3 = zzYbK2;
        FileFormatInfo fileFormatInfo = zzYbK2.zzYcj(zzWFc3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzWFc2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzWCF(zzWFc.zzYcj(stream));
    }

    static zzWXz zzYyt(zzWVE zzWVE2, String string) throws Exception {
        zzXzZ zzXzZ2 = new zzXzZ(zzWVE2);
        if (zzXzZ2.zzW()) {
            zzWXz zzWXz2 = zzXzZ2.zzRS(string);
            return zzWXz2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zz5w(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzYX0.zzYcj("Unexpected digest algorithm: {0}.", n));
    }

    static String zzX0S(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zz5w(n);
    }

    private static void zzYyt(zzWFc zzWFc2, zzWFc zzWFc3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzVYk zzVYk2 = new zzVYk(zzWFc2);
        zzXB4 zzXB42 = bl ? new zzW99(zzVYk2) : new zz47(zzVYk2);
        zzXB42.zzYcj(digitalSignature);
        zzWFc3.zzYZc(0L);
        zzVYk2.zzVQ7(zzWFc3);
    }

    private static void zzYyt(zzWFc zzWFc2, zzWFc zzWFc3, DigitalSignature digitalSignature) throws Exception {
        zzWnX zzWnX2 = new zzWnX(zzWFc2);
        zzXFm zzXFm2 = new zzXFm(zzWnX2);
        zzXFm2.zzYcj(digitalSignature);
        zzWFc3.zzYZc(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWFc zzWFc4 = zzWFc3;
        zzWnX zzWnX3 = zzWnX2;
        zzWnX3.zzYyt(zzWFc4, string, null);
    }

    private static void zzYyt(zzWVE zzWVE2, zzWFc zzWFc2, DigitalSignature digitalSignature, String string) throws Exception {
        zzWXz zzWXz2 = DigitalSignatureUtil.zzYyt(zzWVE2, string);
        zzWXz zzWXz3 = new zzWXz();
        DigitalSignatureUtil.zzYyt((zzWFc)zzWXz2, (zzWFc)zzWXz3, digitalSignature, false);
        zzWVE zzWVE3 = zzXzZ.zzWII(zzWXz3, string);
        zzWVE3.zzVQ7(zzWFc2);
    }

    private static DigitalSignatureCollection zzXOf(zzWFc zzWFc2) throws Exception {
        zzWFc2.zzWzT(0L);
        zzVYk zzVYk2 = new zzVYk(zzWFc2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzWfI zzWfI2 = zzVYk2.zzYyt(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzWfI2 != null) {
            for (zzZ2c zzZ2c2 : zzWfI2.zzWMg()) {
                String string = zzWfI2.zzYyt(zzZ2c2);
                zzWfI zzWfI3 = zzVYk2.zzWj7(string);
                zzWfI zzWfI4 = zzVYk2.zzYyt(zzWfI3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zz5f zz5f2 = zzYcE.zzW6I(zzWfI4.zzYJG().zzWeO());
                zzYuN.zzYyt(zzWfI3.zzZ8W(), zz5f2, new zzX0t(zzVYk2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

