/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz0q;
import com.aspose.words.internal.zzVT1;
import com.aspose.words.internal.zzWFc;
import com.aspose.words.internal.zzWXz;
import com.aspose.words.internal.zzWeF;
import com.aspose.words.internal.zzWo5;
import com.aspose.words.internal.zzXIS;
import com.aspose.words.internal.zzXM9;
import com.aspose.words.internal.zzXXT;
import com.aspose.words.internal.zzXrr;
import com.aspose.words.internal.zzY3h;
import com.aspose.words.internal.zzY3m;
import com.aspose.words.internal.zzYWX;
import com.aspose.words.internal.zzYX0;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.internal.zzZQv;
import com.aspose.words.internal.zzZkN;
import com.aspose.words.internal.zzsv;
import com.aspose.words.zz2P;
import com.aspose.words.zzEb;
import com.aspose.words.zzIi;
import com.aspose.words.zzQ9;
import com.aspose.words.zzRu;
import com.aspose.words.zzVOR;
import com.aspose.words.zzW0k;
import com.aspose.words.zzW6F;
import com.aspose.words.zzW8t;
import com.aspose.words.zzWBK;
import com.aspose.words.zzWRN;
import com.aspose.words.zzWSx;
import com.aspose.words.zzWo4;
import com.aspose.words.zzWzr;
import com.aspose.words.zzX46;
import com.aspose.words.zzXAi;
import com.aspose.words.zzXI5;
import com.aspose.words.zzXSi;
import com.aspose.words.zzXaR;
import com.aspose.words.zzXsP;
import com.aspose.words.zzXvt;
import com.aspose.words.zzY1t;
import com.aspose.words.zzYN;
import com.aspose.words.zzYNm;
import com.aspose.words.zzYUi;
import com.aspose.words.zzYgk;
import com.aspose.words.zzYlj;
import com.aspose.words.zzYq;
import com.aspose.words.zzYte;
import com.aspose.words.zzYzR;
import com.aspose.words.zzZ8b;
import com.aspose.words.zzZCn;
import com.aspose.words.zzZJZ;
import com.aspose.words.zzZJf;
import com.aspose.words.zzZPZ;
import com.aspose.words.zzZcY;
import com.aspose.words.zzZiZ;
import com.aspose.words.zzZnZ;
import com.aspose.words.zzZqK;
import com.aspose.words.zzZvK;
import com.aspose.words.zzjc;
import com.aspose.words.zzr2;
import com.aspose.words.zzyt;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWBK,
zzZCn,
zzZiZ {
    private Document zzZ3M;
    private Node zzHG;
    private Node zzZJ1;
    private zzW0k zzXkY;
    private Font zzZRg;
    private zzYWX<zzW0k> zzWXn;
    private zzYWX<zzjc> zz5N;
    private zzYWX<zzYyt> zzWaH;
    private zzXaR zzX24 = zzXaR.zzWCe();
    private zzYNm zzZ4e = new zzYNm();
    private RowFormat zzML;
    private CellFormat zzWck;
    private zzYWX<zzZJZ> zzZmE;
    private int zzVOW = 0;
    private int zzZgK = -1;
    private int zzZM6;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYZU(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYZU(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYZU(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYyt(documentBuilder.getCurrentSection(), zzVOR.zzZCl(headerFooterType), 0, 0);
    }

    private void zzYZU(int n, int n2, int n3, int n4) {
        this.zzZ3M.ensureMinimum();
        Section section = (Section)this.zzZ3M.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYyt(section, 1, n3, n4);
    }

    private void zzYyt(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzVOR.zzXhb(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZ3M, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZ3M));
            }
        }
        this.zzYyt(story, n2, n3);
    }

    private void zzYyt(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYyt((CompositeNode)paragraph2, n3);
    }

    final void zzYyt(Paragraph paragraph, int n) {
        this.zzYyt((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZ3Q().zzYCg() ? zzYN.zzWCn(this.zzZ3M, fieldName) : zzYN.zzXMC(this.zzZ3Q(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYyt(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYyt(field, isAfter, false);
    }

    private boolean zzYyt(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzYq zzYq2 = field.getFormat().zzXv();
        Inline inline = zzYq2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYyt(inline.zzZi5(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zz2P.zzYyt(this.zzZ3M, bookmarkName) : zz2P.zzYcj(this.zzZ3M, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzYA5() == 6) {
            this.zzYyt((Paragraph)node.zzYoU(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzX46.zzWtd(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYyt(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYyt(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZIw(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYyt(cell, characterIndex);
    }

    private void zzYyt(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzYA5() == 6) {
            this.zzZPZ(node);
        } else {
            Node node2 = node;
            if (zzX46.zzWjy(node2.getNodeType())) {
                Paragraph paragraph = zzX46.zzWtd(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzZPZ(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzYA5() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzZPZ(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzZM6 = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXWR();
            return;
        }
        if (!this.zzYh()) {
            this.zzXWR();
        }
    }

    private boolean zzYh() {
        Node node = this.zzZ3Q();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzZ3Q(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYyt(inline.zzZi5(), true);
            return true;
        }
        return false;
    }

    private void zzXWR() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYyt(documentBuilder.getCurrentParagraph().zzYFL(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZIw(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYgJ() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZ3Q().zzWj7(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzCK();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYyt((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZp7(text, false);
    }

    public void writeln(String text) {
        this.zzZp7(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzVUM();
        Paragraph paragraph = this.getCurrentParagraph();
        zzr2 zzr22 = new zzr2(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZ3M, this.zzX9l(), this.zzXs());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzYcj(this.zzZ3Q(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzr22.dispose();
        }
        if (this.getDocument().zzX2()) {
            zzX46.zzWII((zzXI5)paragraph, this.getDocument().zzX1S());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzXip() {
        zzW0k zzW0k2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzVUM();
        Node node = this.zzZ3Q();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzZnZ(false);
        } else {
            run2 = run = (Run)node.zzZQA(21);
        }
        if (run2 == null && zzYlQ.zzje(node, paragraph.zzWaQ())) {
            run = paragraph.zzWaQ();
        }
        if (run != null) {
            cloneable = run.zzZi5();
            zzW0k2 = (zzW0k)((zzZPZ)cloneable).zzPE();
        } else {
            cloneable = paragraph.zzYFL();
            zzW0k2 = (zzW0k)((zzZPZ)cloneable).zzPE();
        }
        zzW0k zzW0k3 = zzW0k2;
        Paragraph paragraph2 = new Paragraph(this.zzZ3M, this.zzX9l(), zzW0k3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzr2 zzr22 = new zzr2(this.zzZ3M);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYcj(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzr22.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzQ9.zzWCn(this);
    }

    public void insertBreak(int breakType) {
        this.zzWWC(breakType, true);
    }

    final void zzWWC(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzX1n(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzYFf(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzZoS())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzX1n(bl)) {
                        this.zzYFf(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzX1n(bl)) {
                        this.zzYcR(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzX1n(bl)) {
                        this.zzYcR(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzX1n(bl)) {
                        this.zzYcR(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzX1n(bl)) {
                        this.zzYcR(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzX1n(bl)) {
                        this.zzYcR(4);
                    }
                    return;
                }
                case 8: {
                    this.zzYFf(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zz0q.zzWej(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzYX0.zzYcj("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzVUM();
        return zzX46.zzYyt(fieldType, updateField, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzVUM();
        return zzX46.zzYyt(fieldCode, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzVUM();
        return zzX46.zzYyt(fieldCode, fieldValue, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzYlQ.zzYcj((Object)displayText, "displayText");
        zzYlQ.zzYcj((Object)urlOrBookmark, "hrefOrBookmark");
        zzIi zzIi2 = this.zzYcj(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzIi2.zzYcj(documentBuilder.zzaG(88, true));
        return zzX46.zzYyt(zzIi2.getStart(), zzIi2.getSeparator(), zzIi2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzXD5(70);
        if (zz0q.zzWej(name)) {
            this.startBookmark(name);
        }
        this.zzXta(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYa8(70);
        String string = zz0q.zzWej(fieldValue) ? fieldValue : FormField.zz8f;
        Run run = new Run(this.zzZ3M, string, this.zzXs());
        this.insertNode(run);
        Node node = this.zzaG(70, true);
        if (zz0q.zzWej(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzWSx(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYyt((Paragraph)node.zzYoU(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzXD5(71);
        if (zz0q.zzWej(name)) {
            this.startBookmark(name);
        }
        this.zzXta(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzaG(71, false);
        if (zz0q.zzWej(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWSx(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzXD5(83);
        if (zz0q.zzWej(name)) {
            this.startBookmark(name);
        }
        this.zzXta(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzaG(83, false);
        if (zz0q.zzWej(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWSx(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZ3M, footnoteType, !zz0q.zzWej(referenceMark), referenceMark, this.zzXs());
        Style style = this.getDocument().getStyles().zzXFe(zzX46.zzY1J(footnoteType));
        footnote.zzZi5().set(50, style.zzzR());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZ3M);
        Style style2 = this.getDocument().getStyles().zzXFe(zzX46.zzFW(footnoteType));
        paragraph.zzWXJ().set(1000, style2.zzzR());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZ3M, '\u0002', new zzW0k()) : new Run(this.zzZ3M, footnote.getReferenceMark(), new zzW0k());
        inline.zzZi5().set(50, style.zzzR());
        paragraph.appendChild(inline);
        if (zz0q.zzWej(footnoteText)) {
            Node node = this.zzZ3Q();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZPZ(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZUb(zzWFc zzWFc2) throws Exception {
        return this.zzYyt(zzWFc2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZUb(zzWFc.zzYcj(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYyt(zzWFc zzWFc2, double d, double d2) throws Exception {
        return this.zzYyt(zzWFc2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYyt(zzWFc.zzYcj(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzWXz zzWXz2 = new zzWXz();){
            zzXIS.zzYyt(image, zzWXz2);
            Shape shape = this.zzYyt(zzWXz2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzYlQ.zzYcj(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZQv.zzXod(fileName);
        try {
            Shape shape = this.zzYyt((zzWFc)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzWFc)object).close();
            }
        }
    }

    private Shape zzYyt(zzWFc zzWFc2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzWFc2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzYlQ.zzXUn(zzWFc2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYyt(zzWFc.zzYcj(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYyt(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzYyt(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzY3m.zzYbQ(object)) {
            object4 = new zzXIS((byte[])object);
            bl2 = true;
            ((zzWo5)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzZ3M.getCompatibilityOptions().getMswVersion() > 12 || this.zzZ3M.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZ3M, 0);
            object3 = new zzXvt();
            ((zzYte)object3).zzYyt(zzYUi.zz4S("rect"));
            ((zzXvt)object3).zzYyt(new zzZnZ());
            ((zzXvt)object3).zzXsr().zzYwJ().zzWII(this.zzZ3M);
            object2 = new zzXSi();
            ((zzYlj)object2).zzYcj(new zzWo4(this.zzZ3M.zzWZx(), ""));
            ((zzYlj)object2).zzYyt(new zzZcY());
            ((zzWzr)object3).zzYyt((zzYlj)object2);
            shape.zzXzk(75);
            shape.zzXUn((zzWzr)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzZ3M, 75);
        }
        if (zzY3m.zzDE(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzYyt((byte[])object, new zzEb(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzEb(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzY3m.zzWdq((byte[])object2));
                this.zzYyt((zzXvt)shape.zzVL(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXvt)shape.zzVL()).zzXsr().zzYwJ().zzYrr((byte[])object);
            object3 = zzY3m.zzXmr(object);
            object4 = new zzEb(((zzsv)object3).getWidthPoints(), ((zzsv)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzYyt(this.zzXs());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzY3m.zzWCF(object)) {
            d5 = DocumentBuilder.zzYyt(shape, object);
        }
        shape.zzYyt(d3, d4, (zzEb)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYyt(Shape shape, byte[] byArray) throws Exception {
        int n = zzY3m.zzZD6(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzX46.zzX0p(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzX46.zzUh(n);
        return d;
    }

    private void zzYyt(zzXvt zzXvt2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXvt2.zzXsr().zzYwJ().getExtensions();
        try (zzWXz zzWXz2 = new zzWXz(byArray);){
            object = zzX46.zzYyt(zzWXz2, this.zzZ3M);
            ((zzXsP)object).zzYes(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzXsP)object).zzWBY();
            byArray2 = ((zzXsP)object).zzVSi(true);
        }
        zzXvt2.zzXsr().zzYwJ().setExtensions(new zzZkN<zzY1t>());
        object = zzY1t.zzYyt(byArray2, this.zzZ3M);
        zzXvt2.zzXsr().zzYwJ().getExtensions().zzaM(((zzY1t)object).getUri(), (zzY1t)object);
    }

    private Shape zzYyt(zzWFc zzWFc2, String string, boolean bl, zzWFc zzWFc3) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzYNX(string);
        Shape shape = this.zzYyt(zzWFc3, bl, zzZqK2, null);
        zzZJf zzZJf2 = zzXAi.zzYyt(zzWFc2, string, bl);
        return DocumentBuilder.zzYyt(null, false, shape, zzZqK2.zzZh6, zzZJf2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYyt(zzWFc.zzYcj(stream), progId, asIcon, zzWFc.zzYcj(presentation));
    }

    private Shape zzYyt(String string, boolean bl, boolean bl2, zzWFc zzWFc2) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzWeF(zzVT1.zzWmw(string));
        return this.zzYyt(string, bl, bl2, zzWFc2, zzZqK2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYyt(fileName, isLinked, asIcon, zzWFc.zzYcj(presentation));
    }

    private Shape zzYyt(String string, String string2, boolean bl, boolean bl2, zzWFc zzWFc2) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzYNX(string2);
        return this.zzYyt(string, bl, bl2, zzWFc2, zzZqK2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYyt(fileName, progId, isLinked, asIcon, zzWFc.zzYcj(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzWeF(zzVT1.zzWmw(fileName));
        return this.zzYyt(fileName, isLinked, iconFile, iconCaption, zzZqK2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzYNX(progId);
        return this.zzYyt(fileName, isLinked, iconFile, iconCaption, zzZqK2);
    }

    private Shape zzYyt(zzWFc zzWFc2, String string, String string2, String string3) throws Exception {
        zzZqK zzZqK2 = zzZqK.zzYNX(string);
        Shape shape = this.zzYyt(string2, string3, zzZqK2);
        zzZJf zzZJf2 = zzXAi.zzYyt(zzWFc2, string, true);
        return DocumentBuilder.zzYyt(null, false, shape, zzZqK2.zzZh6, zzZJf2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYyt(zzWFc.zzYcj(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYyt(zzyt zzyt2, zzWFc zzWFc2) throws Exception {
        Shape shape = this.zzYhm(zzWFc2);
        shape.zzXzk(201);
        shape.getOleFormat().zzYcj(zzyt2.zzWbD());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzVUM();
        if (this.zzYwY()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzlf(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzW8t zzW8t2 = zzX46.zzYyt(html, options, this);
        zzW8t2.zzX32();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzVUM();
        return zzX46.zzYyt(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzVUM();
        return zzX46.zzYyt(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzW6F zzW6F2 = new zzW6F();
        return zzW6F2.zzYyt(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZvK(this).zzYyt(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZvK(this).zzYyt(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZ3M, 75);
        shape.zzYyt(this.zzXs());
        shape.zzWKT(true);
        shape.getSignatureLine().zzYyt(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYH8(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZy2(this.zzZ3M);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYwY() {
        boolean bl = false;
        if (this.zzZ3Q().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZ3Q().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzlf(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzVUM();
        if (this.zzYgJ() == null) {
            this.startTable();
        }
        if (this.zzYgJ().zzWnw() == 1) {
            this.zzYgJ().zzY2U();
        }
        if (this.zzYgJ().zzWnw() == 3) {
            this.zzYgJ().zzLo();
        }
        return this.zzYgJ().zzY63();
    }

    public Table startTable() {
        this.zzZmE.push(new zzZJZ(this));
        return this.zzYgJ().startTable();
    }

    public Table endTable() {
        if (this.zzYgJ() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYgJ().endTable();
        this.zzZmE.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYgJ() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYgJ().endRow();
        if (this.zzZRg != null && this.zzZRg.getHidden()) {
            row.zzY3D().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZ3M, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZ3M, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXGf();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZ3M, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXJp();
        bookmarkStart.zzZbI(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXGf();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXJp();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZ3M, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzXe9(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZ3M);
        this.zzZgK = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZgK == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZ3M, this.zzZgK);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZ3M, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYlQ.zzYcj((Object)importFormatOptions, "ImportFormatOptions");
        this.zzVUM();
        return zzWRN.zzYyt(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZ3M;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZ3M) {
            return;
        }
        this.zzZ3M = value;
        this.zzZPZ(null);
        this.zzXkY = new zzW0k();
        this.zzWXn = null;
        this.zz5N = null;
        this.zzZRg = null;
        this.zzZmE = new zzYWX();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZRg == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZRg = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZRg;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzML == null) {
            this.zzML = new RowFormat(this);
        }
        return this.zzML;
    }

    public CellFormat getCellFormat() {
        if (this.zzWck == null) {
            this.zzWck = new CellFormat(this);
        }
        return this.zzWck;
    }

    final void zzZjW(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzW0k zzW0k2 = this.getCurrentParagraph().zzYFL();
        this.zzZ4P().push(new zzYyt(this.zzXs(), (zzW0k)zzW0k2.zzPE()));
    }

    public void popFont() {
        zzYWX<zzYyt> zzYWX2 = this.zzZ4P();
        if (zzYWX2.size() > 0) {
            zzYyt zzYyt2 = (zzYyt)this.zzZ4P().pop();
            this.zzYyt(zzYyt2.zzZi5(), false);
            this.getCurrentParagraph().zzWLh(zzYyt2.zzWyq());
        }
    }

    final void zzXwN() {
        this.zzZWX().push(this.zzXs());
    }

    final void zzWWx() {
        zzYWX<zzW0k> zzYWX2 = this.zzZWX();
        if (zzYWX2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYyt((zzW0k)documentBuilder.zzZWX().pop(), false);
        }
    }

    final void zzXeA() {
        this.zzW48().push(this.zzX9l());
    }

    final void zzZtd() {
        zzYWX<zzjc> zzYWX2 = this.zzW48();
        if (zzYWX2.size() > 0) {
            this.getCurrentParagraph().zzYyt((zzjc)this.zzW48().pop());
        }
    }

    final zzIi zzYcj(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzXD5(88);
        zzRu zzRu2 = new zzRu();
        zzRu2.setTarget(string2);
        zzRu2.setScreenTip(string3);
        if (bl) {
            zzRu2.setSubAddress(string);
        } else {
            zzRu2.setAddress(zzXrr.zzZWp(string));
            zzRu2.setSubAddress(zzXrr.zzWez(string));
        }
        this.zzXta(zzRu2.zzYe());
        FieldSeparator fieldSeparator = this.zzYa8(88);
        return new zzIi(fieldStart, fieldSeparator, null);
    }

    final zzIi zzY7U(String string, String string2, String string3) {
        boolean bl = zzXrr.zzZDN(string);
        String string4 = bl ? zzXrr.zzWez(string) : string;
        return this.zzYcj(string4, bl, string2, string3);
    }

    final FieldEnd zzZFu() {
        return this.zzaG(88, true);
    }

    final zzW0k zzXs() {
        zzW0k zzW0k2 = this.zzXkY;
        return (zzW0k)zzW0k2.zzPE();
    }

    final zzjc zzX9l() {
        zzjc zzjc2 = this.getCurrentParagraph().zzWXJ();
        return (zzjc)zzjc2.zzPE();
    }

    final zzXaR zzXqp() {
        zzXaR zzXaR2 = this.zzY3D();
        return (zzXaR)zzXaR2.zzPE();
    }

    final zzYNm zzYzl() {
        zzYNm zzYNm2 = this.zzW9N();
        return (zzYNm)zzYNm2.zzPE();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZ3Q(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZ3Q().getNodeType() == 8;
    }

    private void zzZp7(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzVOR.zzXM2(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzWIt(string2.substring(n4, n4 + n2));
                }
                switch (this.zzVOW) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzYFf(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzWIt(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzVUM();
        if (this.zzYgJ() != null && this.zzYgJ().zzWnw() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzZ3Q().getParentNode().insertBefore(node, this.zzZ3Q());
    }

    final void zzZnI(int n) {
        this.zzX1n(true);
        this.zzYcR(n);
    }

    private void zzYcR(int n) {
        this.insertParagraph();
        zzr2 zzr22 = new zzr2(this.getDocument());
        try {
            zzYzR zzYzR2 = this.getCurrentSection().zzYbv();
            zzYzR zzYzR3 = (zzYzR)zzYzR2.zzPE();
            Section section = new Section(this.zzZ3M, zzYzR3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZ3M));
            this.zzZ3M.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYcj(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzr22.dispose();
        }
    }

    final FieldStart zzXD5(int n) {
        this.zzVUM();
        return zzX46.zzYyt(n, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzXta(String string) {
        return zzX46.zzYcj(string, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzaG(int n, boolean bl) {
        return zzX46.zzYcj(n, bl, this.zzXs(), this.zzZ3Q(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzYa8(int n) {
        return zzX46.zzYcj(n, this.zzXs(), this.zzZ3Q(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzWSx(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZ3M, new zzZ8b(), this.zzXs());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzX1n(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYgJ() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZIw(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzWIt(String string) {
        if (this.zzZ1A(string)) {
            zzWeF zzWeF2 = new zzWeF(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzY3h zzY3h2 : zzWeF2.zzYp(this.getParagraphFormat().getBidi())) {
                zzWSx zzWSx2 = zzWSx.zzMx(zzY3h2.zzap());
                zzW0k zzW0k2 = this.zzXs();
                zzW0k2.zzY7U(265, zzWSx2);
                if (zzY3h2.zzZco()) {
                    zzW0k2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZ3M, zzY3h2.getText(), zzW0k2);
                this.insertNode(run);
            }
            return;
        }
        this.zzYFf(string);
    }

    private boolean zzZ1A(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXM9.zzZf7(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYyt(zzW0k zzW0k2, boolean bl) {
        zzW0k zzW0k3;
        if (bl) {
            zzW0k zzW0k4 = zzW0k2;
            zzW0k3 = (zzW0k)zzW0k4.zzPE();
        } else {
            zzW0k3 = zzW0k2;
        }
        this.zzXkY = zzW0k3;
    }

    final void zzWE3() {
        this.zzXkY.clear();
    }

    final void zzXRb() {
        if (this.zzXGf() != null) {
            zzYNm zzYNm2;
            zzYNm zzYNm3 = zzYNm2 = this.zzXGf().zzW9N();
            this.zzZ4e = (zzYNm)zzYNm3.zzPE();
            zzYNm2.zzYcj(this.zzZ4e);
        }
    }

    private Shape zzYyt(String string, boolean bl, boolean bl2, zzWFc zzWFc2, zzZqK zzZqK2) throws Exception {
        if (zzZqK2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYyt(zzWFc2, bl2, zzZqK2, string);
        zzZJf zzZJf2 = zzXAi.zzYyt(string, bl, bl2, zzZqK2);
        return DocumentBuilder.zzYyt(string, bl, shape, zzZqK2.zzZh6, zzZJf2);
    }

    private Shape zzYyt(String string, boolean bl, String string2, String string3, zzZqK zzZqK2) throws Exception {
        if (zzZqK2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzVT1.zzYEY(string);
        }
        Shape shape = string2 != null ? this.zzZD6(string2, string3) : this.zzYyt(null, string3, zzZqK2);
        zzZJf zzZJf2 = zzXAi.zzYyt(string, bl, true, zzZqK2);
        return DocumentBuilder.zzYyt(string, bl, shape, zzZqK2.zzZh6, zzZJf2);
    }

    private static Shape zzYyt(String string, boolean bl, Shape shape, String string2, zzZJf zzZJf2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXzk(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYcj(zzZJf2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYyt(zzWFc zzWFc2, boolean bl, zzZqK zzZqK2, String string) throws Exception {
        if (zzZqK2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzWFc2 != null) {
            return this.zzYhm(zzWFc2);
        }
        if (!bl) {
            return this.zz3r(zzXAi.zzZ8j().get("normal"));
        }
        String string2 = string != null ? zzVT1.zzYEY(string) : zzXAi.zzX3e(zzZqK2.zzW7D);
        return this.zzYyt(zzZqK2, string2);
    }

    private Shape zzYyt(String string, String string2, zzZqK zzZqK2) throws Exception {
        if (zzZqK2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzXAi.zzX3e(zzZqK2.zzW7D);
        }
        if (string != null) {
            return this.zzZD6(string, string2);
        }
        return this.zzYyt(zzZqK2, string2);
    }

    private Shape zzYyt(zzZqK zzZqK2, String string) throws Exception {
        if (zzZqK2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzXAi.zzCi(zzZqK2.zzW7D);
        zzXXT zzXXT2 = new zzXXT(byArray, null, string, this.getDocument().zzW4r());
        return this.zz3r(zzXXT2.zz4l());
    }

    private Shape zzZD6(String string, String string2) throws Exception {
        zzXXT zzXXT2 = new zzXXT(string, string2, this.getDocument().zzW4r());
        return this.zz3r(zzXXT2.zz4l());
    }

    private Shape zzYhm(zzWFc zzWFc2) throws Exception {
        byte[] byArray = zzYlQ.zzXUn(zzWFc2);
        return this.zz3r(byArray);
    }

    private Shape zz3r(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZ3M, 1);
        shape.zzXzk(75);
        shape.zzYyt(this.zzXs());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYH8(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYyt(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYcj(compositeNode, n);
            return;
        }
        this.zzWII(compositeNode, n);
    }

    private void zzYcj(CompositeNode compositeNode, int n) {
        zzYgk zzYgk2 = zzYgk.zzXF2(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzYgk2.zzYyt(null, true, true, true, false, true);
            node = zzYgk2.getNode();
            if (zzYgk2.zzXCP() && (!node.isComposite() || node.zzYA5() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzZZv().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzYyt(null, node);
            this.zzZM6 = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzWII(CompositeNode compositeNode, int n) {
        zzYgk zzYgk2 = zzYgk.zzX0S(compositeNode);
        while (zzYgk2.getNode() != compositeNode || !zzYgk2.zzXCP()) {
            int n2;
            Node node = zzYgk2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZZv().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYyt(null, node);
                this.zzZM6 = n;
                return;
            }
            while (zzYgk2.zzYyt(null, false, true, true, false, true) && zzYgk2.zzXCP() && zzYgk2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzVUM() {
        int n = this.zzZM6;
        if (n == 0) {
            return;
        }
        this.zzZM6 = 0;
        Run run = zzYlQ.zzYyt((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZxT(n);
        }
    }

    private Run zzYFf(String string) {
        Run run = new Run(this.zzZ3M, string, this.zzXs());
        this.insertNode(run);
        return run;
    }

    final boolean zzZhW() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzgp() {
        return this.zzVOW;
    }

    final void zzXDz(int n) {
        this.zzVOW = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzZ3Q();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZ3Q();
        }
        return (Paragraph)this.zzZ3Q().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzZJZ zzYgJ() {
        zzYWX<zzZJZ> zzYWX2 = this.zzZmE;
        if (zzYWX2.size() > 0) {
            return (zzZJZ)this.zzZmE.peek();
        }
        return null;
    }

    private Cell zzXGf() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYIF();
    }

    private zzYWX<zzW0k> zzZWX() {
        if (this.zzWXn == null) {
            this.zzWXn = new zzYWX();
        }
        return this.zzWXn;
    }

    private zzYWX<zzjc> zzW48() {
        if (this.zz5N == null) {
            this.zz5N = new zzYWX();
        }
        return this.zz5N;
    }

    private zzYWX<zzYyt> zzZ4P() {
        if (this.zzWaH == null) {
            this.zzWaH = new zzYWX();
        }
        return this.zzWaH;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXkY.zzXzy(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzWHV(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzWHV(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXkY.zzY7U(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzVPZ()) {
            this.getCurrentParagraph().zzYFL().zzY7U(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXkY.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXkY.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzVPZ()) {
            this.getCurrentParagraph().zzYFL().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzY3D().zzXzy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzY3D().zzWLg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzY3D().zzWS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzY3D().zzY7U(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzY3D().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzY3D().clear();
        zzXaR.zzWCe().zzYcj(this.zzY3D());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzW9N().zzXzy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzW9N().zzWLg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzW9N().zzWS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzYlQ.zzYyt(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzXGf() != null ? this.zzXGf().getCellFormat() : this.getCellFormat();
            border.zzYyt(cellFormat);
        }
        this.zzW9N().zzY7U(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzW9N().clear();
    }

    private Node zzZ3Q() {
        Node node = this.zzHG != null && this.zzHG.getParentNode() == null ? this.zzZJ1 : this.zzHG;
        if (node != null && node.zzYA5() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZPZ(Node node) {
        this.zzHG = node;
        if (this.zzHG != null) {
            this.zzZJ1 = this.zzHG.getParentNode();
        }
    }

    private zzXaR zzY3D() {
        if (this.zzYgJ() != null && this.zzYgJ().zzWnw() == 1) {
            return this.zzX24;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzY3D();
        }
        return this.zzX24;
    }

    private zzYNm zzW9N() {
        if (this.zzYgJ() != null && this.zzYgJ().zzWnw() != 3) {
            return this.zzZ4e;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYIF().zzW9N();
        }
        return this.zzZ4e;
    }

    static final class zzYyt {
        private zzW0k zzXkY;
        private zzW0k zzW82;

        public zzYyt(zzW0k zzW0k2, zzW0k zzW0k3) {
            this.zzXkY = zzW0k2;
            this.zzW82 = zzW0k3;
        }

        public final zzW0k zzZi5() {
            return this.zzXkY;
        }

        public final zzW0k zzWyq() {
            return this.zzW82;
        }
    }
}

