/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzVT1;
import com.aspose.words.internal.zzY0D;

public abstract class SaveOptions {
    private boolean zzZSE;
    private IDocumentSavingCallback zzZz0;
    private boolean zzZH5 = true;
    private boolean zzZ9s = false;
    private boolean zzZvC = true;
    private boolean zzWya;
    private String zzYQ2;
    private boolean zzW1E;
    private boolean zzZKM = false;
    private boolean zzvC = true;
    private int zzXCx = 1;
    private int zzYoz = 1;
    private int zzXw1 = 0;
    private String zzVXN = "";
    private boolean zzYJs = true;
    private boolean zzZDI = true;
    private boolean zzYjs;
    private boolean zzYI2;
    private int zzZht = 0;
    private boolean zzLW = true;
    private boolean zzZM1 = false;
    private boolean zzXiT = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZSJ() {
        return false;
    }

    boolean zzWY2() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZvC;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZvC = value;
    }

    public String getTempFolder() {
        return this.zzYQ2;
    }

    public void setTempFolder(String value) {
        this.zzYQ2 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWya;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWya = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzW1E;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzW1E = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZKM;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZKM = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzvC;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzvC = value;
    }

    public int getDmlRenderingMode() {
        return this.zzXCx;
    }

    public void setDmlRenderingMode(int value) {
        this.zzXCx = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXw1;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXw1 = value;
    }

    public int getImlRenderingMode() {
        return this.zzYoz;
    }

    public void setImlRenderingMode(int value) {
        this.zzYoz = value;
    }

    public String getDefaultTemplate() {
        return this.zzVXN;
    }

    public void setDefaultTemplate(String value) {
        this.zzVXN = value;
    }

    public boolean getUpdateFields() {
        return this.zzYJs;
    }

    public void setUpdateFields(boolean value) {
        this.zzYJs = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYjs;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYjs = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYI2;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYI2 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzZM1;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzZM1 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZ9s;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZ9s = value;
    }

    final boolean zz3P() {
        return this.zzZDI;
    }

    final boolean zzWbF() {
        return this.zzLW;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYFz(zzY0D.zzWt1(zzVT1.zzWmw(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzZht;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzZht = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZz0;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZz0 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZSE;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZSE = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzXiT;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzXiT = value;
    }

    final boolean zzYeg() {
        return this.zzZH5;
    }
}

